<?php
/**
* Auto detect language and currency
*
* NOTICE OF LICENSE
*
* This product is licensed for one customer to use on one installation (test stores and multishop included).
* Site developer has the right to modify this module to suit their needs, but can not redistribute the module in
* whole or in part. Any other use of this module constitues a violation of the user agreement.
*
* DISCLAIMER
*
* NO WARRANTIES OF DATA SAFETY OR MODULE SECURITY
* ARE EXPRESSED OR IMPLIED. USE THIS MODULE IN ACCORDANCE
* WITH YOUR MERCHANT AGREEMENT, KNOWING THAT VIOLATIONS OF
* PCI COMPLIANCY OR A DATA BREACH CAN COST THOUSANDS OF DOLLARS
* IN FINES AND DAMAGE A STORES REPUTATION. USE AT YOUR OWN RISK.
*
*  @author    idnovate
*  @copyright 2017 idnovate
*  @license   See above
*/

class AutoLanguageCurrencySetCookieModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
	    $this->setRedirectCookie();
    }

	private function setRedirectCookie($domain = null)
	{
		if ($domain == null) {
			$domain = $this->getDomain();
		}
		if (PHP_VERSION_ID <= 50200) { /* PHP version > 5.2.0 */
			setcookie('alc_redirect2', true, 0, '/', $domain, false);
		} else {
			setcookie('alc_redirect2', true, 0, '/', $domain, false, true);
		}
		$this->ajaxDie('1');
	}

	protected function getDomain($shared_urls = null)
	{
		$r = '!(?:(\w+)://)?(?:(\w+)\:(\w+)@)?([^/:]+)?(?:\:(\d*))?([^#?]+)?(?:\?([^#]+))?(?:#(.+$))?!i';

		if (!preg_match($r, Tools::getHttpHost(false, false), $out) || !isset($out[4])) {
			return false;
		}

		if (preg_match('/^(((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]{1}[0-9]|[1-9]).)'.
		               '{1}((25[0-5]|2[0-4][0-9]|[1]{1}[0-9]{2}|[1-9]{1}[0-9]|[0-9]).)'.
		               '{2}((25[0-5]|2[0-4][0-9]|[1]{1}[0-9]{2}|[1-9]{1}[0-9]|[0-9]){1}))$/', $out[4])) {
			return false;
		}
		if (!strstr(Tools::getHttpHost(false, false), '.')) {
			return false;
		}

		$domain = false;
		if ($shared_urls !== null) {
			foreach ($shared_urls as $shared_url) {
				if ($shared_url != $out[4]) {
					continue;
				}
				if (preg_match('/^(?:.*\.)?([^.]*(?:.{2,4})?\..{2,3})$/Ui', $shared_url, $res)) {
					$domain = '.'.$res[1];
					break;
				}
			}
		}
		if (!$domain) {
			$domain = $out[4];
		}
		return $domain;
	}
}
